
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	
	[TestFixture]
	public class DAL_LabTest : BaseTest 
	{
		private DataTable _dtSpecimenTestThreshold;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				Guid sttGuid = Guid.NewGuid();
				DataTable dtSTT = SprocHelper.GetInsertSpecimenTestThresholdSprocTable(sttGuid, new Random().Next(1111111,9999999).ToString());
				new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertSpecimenTestThreshold.StoredProcName, dtSTT);

				this._dtSpecimenTestThreshold = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTestThreshold WHERE SpecimenTestThresholdGuid = '" + sttGuid.ToString() + "'");

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetLabTests_Pass()
		{
			int reportTypeId = System.Convert.ToInt32(this._dtSpecimenTestThreshold.Rows[0][TABLES.SpecimenTestThreshold.ReportTypeId]);

			DataTable dtTest = DAL.LabTest.GetLabTests(reportTypeId);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid), TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.ComponentClassId), TABLES.SpecimenTestThreshold.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.LabTestId), TABLES.SpecimenTestThreshold.LabTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.VistaLaboratoryTestName), TABLES.SpecimenTestThreshold.VistaLaboratoryTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.SpecimenTypeCode), TABLES.SpecimenTestThreshold.SpecimenTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenType.SpecimenTypeText), TABLES.SpecimenType.SpecimenTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.ThresholdResult), TABLES.SpecimenTestThreshold.ThresholdResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.ReportTypeId), TABLES.SpecimenTestThreshold.ReportTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.DivisionCode), TABLES.SpecimenTestThreshold.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.RecordStatusCode), TABLES.SpecimenTestThreshold.RecordStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.LastUpdateUser), TABLES.SpecimenTestThreshold.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.RowVersion), TABLES.SpecimenTestThreshold.RowVersion);
		}

		[Test]
		public void GetLabTests_Fail()
		{
			DataTable dtTest = DAL.LabTest.GetLabTests(int.MinValue);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSpecimenTestThresholds_Pass()
		{
			int componentClassId = System.Convert.ToInt32(this._dtSpecimenTestThreshold.Rows[0][TABLES.SpecimenTestThreshold.ComponentClassId]);
			string labTestId = this._dtSpecimenTestThreshold.Rows[0][TABLES.SpecimenTestThreshold.LabTestId].ToString();

			DataTable dtTest = DAL.LabTest.GetSpecimenTestThresholds(componentClassId, labTestId);

			Assert.IsTrue(dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.ThresholdResult), TABLES.SpecimenTestThreshold.ThresholdResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTestThreshold.VistaLaboratoryTestName), TABLES.SpecimenTestThreshold.VistaLaboratoryTestName);
		}

		[Test]
		public void GetSpecimenTestThresholds_Fail()
		{
			DataTable dtTest = DAL.LabTest.GetSpecimenTestThresholds(int.MinValue, string.Empty);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveLabTests_Pass()
		{
			//Call directly to Common.StoredProcedure.TransactionalGetValue -- See those unit tests
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveLabTests_Fail()
		{
			//Call directly to Common.StoredProcedure.TransactionalGetValue -- See those unit tests
		}
	}
}
#endif



